Rem CropMarks.vbs
Rem An InDesign VBScript
Rem
Rem Draws crop marks and/or registration marks around the selected object or objects.
Rem
Rem For more on InDesign/InCopy scripting see the documentation included in the Scripting SDK 
Rem available at http://www.adobe.com/devnet/indesign/sdk.html
Rem or drop by the InDesign scripting user to user forum at http://www.adobeforums.com.
Rem
main
Function main()
	ReDim myObjectList(0)
	Set myInDesign = CreateObject("InDesign.Application.2021")
	Rem Set the user interaction level to allow the display of dialog boxes and alerts.
	myInDesign.ScriptPreferences.UserInteractionLevel = idUserInteractionLevels.idInteractWithAll
	If myInDesign.Documents.Count <> 0 Then
	    If myInDesign.Selection.Count <> 0 Then
	        For myCounter = 1 To myInDesign.Selection.Count
	            Select Case TypeName(myInDesign.Selection.Item(myCounter))
	                Case "Rectangle", "Oval", "Polygon", "GraphicLine", "Button", "Group", "TextFrame"
	                    If Not (IsEmpty(myObjectList(0))) Then
	                        ReDim Preserve myObjectList(UBound(myObjectList) + 1)
	                    End If
	                    Set myObjectList(UBound(myObjectList)) = myInDesign.Selection.Item(myCounter)
	            End Select
	        Next
	        If Not (IsEmpty(myObjectList(0))) Then
	            myDisplayDialog myInDesign, myObjectList
	        End If
	    Else
	        MsgBox ("Nothing is selected. Please select an object and try again.")
	    End If
	Else
	    MsgBox ("Please open a document, select an object, and try again.")
	End If
End function
Function myDisplayDialog(myInDesign, myObjectList)
Set myDialog = myInDesign.Dialogs.Add
myDialog.Name = "CropMarks"
With myDialog.DialogColumns.Add
    Set myCropMarksGroup = .EnablingGroups.Add
    myCropMarksGroup.StaticLabel = "Crop Marks"
    myCropMarksGroup.CheckedState = True
    With myCropMarksGroup.DialogColumns.Add
        With .StaticTexts.Add
            .StaticLabel = "Options:"
        End With
    End With
    With myCropMarksGroup.DialogColumns.Add
        With .StaticTexts.Add
            .StaticLabel = "Length:"
        End With
        With .StaticTexts.Add
            .StaticLabel = "Offset:"
        End With
        With .StaticTexts.Add
            .StaticLabel = "Stroke Weight:"
        End With
    End With
    With myCropMarksGroup.DialogColumns.Add
        Set myCropMarkLengthField = .MeasurementEditboxes.Add
        myCropMarkLengthField.EditUnits = idMeasurementUnits.idPoints
        myCropMarkLengthField.EditValue = 6
        Set myCropMarkOffsetField = .MeasurementEditboxes.Add
        myCropMarkOffsetField.EditUnits = idMeasurementUnits.idPoints
        myCropMarkOffsetField.EditValue = 3
        Set myCropMarkStrokeWeightField = .MeasurementEditboxes.Add
        myCropMarkStrokeWeightField.EditUnits = idMeasurementUnits.idPoints
        myCropMarkStrokeWeightField.EditValue = 0.25
    End With
    Set myRegMarksGroup = .EnablingGroups.Add
    myRegMarksGroup.StaticLabel = "Registration Marks"
    myRegMarksGroup.CheckedState = True
    With myRegMarksGroup.DialogColumns.Add
        With .StaticTexts.Add
            .StaticLabel = "Options:"
        End With
    End With
    With myRegMarksGroup.DialogColumns.Add
        With .StaticTexts.Add
            .StaticLabel = "Inside Target Radius:"
        End With
        With .StaticTexts.Add
            .StaticLabel = "Outside Target Radius:"
        End With
        With .StaticTexts.Add
            .StaticLabel = "Outside Radius:"
        End With
        With .StaticTexts.Add
            .StaticLabel = "Offset:"
        End With
        With .StaticTexts.Add
            .StaticLabel = "Stroke Weight:"
        End With
    End With
    With myRegMarksGroup.DialogColumns.Add
        Set myRegMarkInnerRadiusField = .MeasurementEditboxes.Add
        myRegMarkInnerRadiusField.EditUnits = idMeasurementUnits.idPoints
        myRegMarkInnerRadiusField.EditValue = 2
        Set myRegMarkOuterRadiusField = .MeasurementEditboxes.Add
        myRegMarkOuterRadiusField.EditUnits = idMeasurementUnits.idPoints
        myRegMarkOuterRadiusField.EditValue = 4
        Set myRegMarkRadiusField = .MeasurementEditboxes.Add
        myRegMarkRadiusField.EditUnits = idMeasurementUnits.idPoints
        myRegMarkRadiusField.EditValue = 6
        Set myRegMarkOffsetField = .MeasurementEditboxes.Add
        myRegMarkOffsetField.EditUnits = idMeasurementUnits.idPoints
        myRegMarkOffsetField.EditValue = 3
        Set myRegMarkStrokeWeightField = .MeasurementEditboxes.Add
        myRegMarkStrokeWeightField.EditUnits = idMeasurementUnits.idPoints
        myRegMarkStrokeWeightField.EditValue = 0.25
    End With
    With .BorderPanels.Add
        With .StaticTexts.Add
            .StaticLabel = "Draw Marks Around:"
        End With
        Set myRangeButtons = .RadiobuttonGroups.Add
        With myRangeButtons.RadiobuttonControls.Add
            .StaticLabel = "Each Object"
            .CheckedState = True
        End With
        With myRangeButtons.RadiobuttonControls.Add
            .StaticLabel = "Entire Selection"
        End With
    End With
End With
myReturn = myDialog.Show
If myReturn = True Then
    Rem Get the values from the dialog box.
    myDoCropMarks = myCropMarksGroup.CheckedState
    myDoRegMarks = myRegMarksGroup.CheckedState
    myCropMarkLength = myCropMarkLengthField.EditValue
    myCropMarkOffset = myCropMarkOffsetField.EditValue
    myCropMarkStrokeWeight = myCropMarkStrokeWeightField.EditValue
    myRegMarkInnerRadius = myRegMarkInnerRadiusField.EditValue
    myRegMarkOuterRadius = myRegMarkOuterRadiusField.EditValue
    myRegMarkRadius = myRegMarkRadiusField.EditValue
    myRegMarkOffset = myRegMarkOffsetField.EditValue
    myRegMarkStrokeWeight = myRegMarkStrokeWeightField.EditValue
    myRange = myRangeButtons.SelectedButton
    myDialog.Destroy
    If ((myDoCropMarks <> False) Or (myDoRegMarks <> False)) Then
    Rem Store the current measurement units.
    myOldXUnits = myInDesign.ActiveDocument.ViewPreferences.HorizontalMeasurementUnits
    myOldYUnits = myInDesign.ActiveDocument.ViewPreferences.VerticalMeasurementUnits
    Rem Set the measurement units to points.
    myInDesign.ActiveDocument.ViewPreferences.HorizontalMeasurementUnits = idMeasurementUnits.idPoints
    myInDesign.ActiveDocument.ViewPreferences.VerticalMeasurementUnits = idMeasurementUnits.idPoints
    Rem Draw the printers marks.
        myDrawPrintersMarks myInDesign, myRange, myDoCropMarks, myDoRegMarks, myCropMarkLength, myCropMarkOffset, myCropMarkStrokeWeight, myRegMarkInnerRadius, myRegMarkOuterRadius, myRegMarkRadius, myRegMarkOffset, myRegMarkStrokeWeight, myObjectList
    Rem Reset the measurement units.
    myInDesign.ActiveDocument.ViewPreferences.HorizontalMeasurementUnits = myOldXUnits
    myInDesign.ActiveDocument.ViewPreferences.VerticalMeasurementUnits = myOldYUnits
    Else
        myDialog.Destroy
    End If
End If
End Function

Function myDrawPrintersMarks(myInDesign, myRange, myDoCropMarks, myDoRegMarks, myCropMarkLength, myCropMarkOffset, myCropMarkStrokeWeight, myRegMarkInnerRadius, myRegMarkOuterRadius, myRegMarkRadius, myRegMarkOffset, myRegMarkStrokeWeight, myObjectList)
    Set myDocument = myInDesign.ActiveDocument
    myOldRulerOrigin = myDocument.ViewPreferences.RulerOrigin
    myDocument.ViewPreferences.RulerOrigin = idRulerOrigin.idSpreadOrigin
    Rem Create a layer to hold the printers marks (if it does not already exist).
    Err.Clear
    On Error Resume Next
    Set myLayer = myDocument.Layers.Item("CropMarks")
    If Err.Number <> 0 Then
        Set myLayer = myDocument.Layers.Add
        myLayer.Name = "CropMarks"
        Err.Clear
    End If
    On Error GoTo 0
    Rem Get references to the Registration color, Paper color, and the None swatch.
    Set myRegistrationSwatch = myDocument.Swatches.Item("Registration")
    Set myPaperSwatch = myDocument.Swatches.Item("Paper")
    Set myNoneSwatch = myDocument.Swatches.Item("None")
    Rem Process the objects in the selection.
    For myCounter = 0 To UBound(myObjectList)
        Set myObject = myObjectList(myCounter)
	myBounds = myObject.VisibleBounds
        Rem Set up some initial bounding box values.
        If myCounter = 0 Then
            myX1 = myBounds(1)
            myY1 = myBounds(0)
            myX2 = myBounds(3)
            myY2 = myBounds(2)
        End If
        If myRange = 0 Then
            If myDoCropMarks = True Then
                myDrawCropMarks myInDesign, myBounds(1), myBounds(0), myBounds(3), myBounds(2), myCropMarkLength, myCropMarkOffset, myCropMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
            End If
            If myDoRegMarks = True Then
                myDrawRegMarks myInDesign, myBounds(1), myBounds(0), myBounds(3), myBounds(2), myRegMarkOffset, myRegMarkInnerRadius, myRegMarkOuterRadius, myRegMarkRadius, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myPaperSwatch, myLayer
            End If
        Else
            Rem Compare the bounds values to the stored bounds.
            Rem If a given bounds value is less than (for x1 and y1) or
            Rem greater than (for x2 and y2) the stored value,
            Rem then replace the stored value with the bounds value.
            If myBounds(0) < myY1 Then
                myY1 = myBounds(0)
            End If
            If myBounds(1) < myX1 Then
                myX1 = myBounds(1)
            End If
            If myBounds(2) > myY2 Then
                myY2 = myBounds(2)
            End If
            If myBounds(3) > myX2 Then
                myX2 = myBounds(3)
            End If
        End If
    Next
    If myRange <> 0 Then
            If myDoCropMarks = True Then
                myDrawCropMarks myInDesign, myX1, myY1, myX2, myY2, myCropMarkLength, myCropMarkOffset, myCropMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
            End If
            If myDoRegMarks = True Then
                myDrawRegMarks myInDesign, myX1, myY1, myX2, myY2, myRegMarkOffset, myRegMarkInnerRadius, myRegMarkOuterRadius, myRegMarkRadius, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myPaperSwatch, myLayer
            End If
    End If
    myDocument.ViewPreferences.RulerOrigin = myOldRulerOrigin
End Function
Function myDrawCropMarks(myInDesign, myX1, myY1, myX2, myY2, myCropMarkLength, myCropMarkOffset, myCropMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer)
    Rem Upper left crop mark pair.
    myDrawLine myInDesign, Array(myY1, myX1 - myCropMarkOffset, myY1, myX1 - (myCropMarkOffset + myCropMarkLength)), myCropMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myDrawLine myInDesign, Array(myY1 - myCropMarkOffset, myX1, myY1 - (myCropMarkOffset + myCropMarkLength), myX1), myCropMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    Rem Lower left crop mark pair.
    myDrawLine myInDesign, Array(myY2, myX1 - myCropMarkOffset, myY2, myX1 - (myCropMarkOffset + myCropMarkLength)), myCropMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myDrawLine myInDesign, Array(myY2 + myCropMarkOffset, myX1, myY2 + myCropMarkOffset + myCropMarkLength, myX1), myCropMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    Rem Upper right crop mark pair.
    myDrawLine myInDesign, Array(myY1, myX2 + myCropMarkOffset, myY1, myX2 + myCropMarkOffset + myCropMarkLength), myCropMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myDrawLine myInDesign, Array(myY1 - myCropMarkOffset, myX2, myY1 - (myCropMarkOffset + myCropMarkLength), myX2), myCropMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    Rem Lower left crop mark pair.
    myDrawLine myInDesign, Array(myY2, myX2 + myCropMarkOffset, myY2, myX2 + myCropMarkOffset + myCropMarkLength), myCropMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myDrawLine myInDesign, Array(myY2 + myCropMarkOffset, myX2, myY2 + myCropMarkOffset + myCropMarkLength, myX2), myCropMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
End Function

Function myDrawRegMarks(myInDesign, myX1, myY1, myX2, myY2, myRegMarkOffset, myRegMarkInnerRadius, myRegMarkOuterRadius, myRegMarkRadius, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myPaperSwatch, myLayer)
    myXCenter = myX1 + ((myX2 - myX1) / 2)
    myYCenter = myY1 + ((myY2 - myY1) / 2)
    myTargetCenter = myRegMarkOffset + (myRegMarkOuterRadius)
    Rem Top registration target.
    myBounds = Array((myY1 - myTargetCenter) - myRegMarkOuterRadius, myXCenter - myRegMarkOuterRadius, (myY1 - myTargetCenter) + myRegMarkOuterRadius, myXCenter + myRegMarkOuterRadius)
    myDrawTarget myInDesign, myBounds, myRegMarkStrokeWeight, myNoneSwatch, myRegistrationSwatch, myLayer
    myBounds = Array(myY1 - (myTargetCenter + myRegMarkRadius), myXCenter, (myY1 - myTargetCenter) + myRegMarkRadius, myXCenter)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myBounds = Array(myY1 - myTargetCenter, myXCenter - myRegMarkRadius, myY1 - myTargetCenter, myXCenter + myRegMarkRadius)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myBounds = Array((myY1 - myTargetCenter) - myRegMarkInnerRadius, myXCenter - myRegMarkInnerRadius, (myY1 - myTargetCenter) + myRegMarkInnerRadius, myXCenter + myRegMarkInnerRadius)
    myDrawTarget myInDesign, myBounds, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myBounds = Array((myY1 - myTargetCenter) - myRegMarkInnerRadius, myXCenter, (myY1 - myTargetCenter) + myRegMarkInnerRadius, myXCenter)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myPaperSwatch, myNoneSwatch, myLayer
    myBounds = Array(myY1 - myTargetCenter, myXCenter - myRegMarkInnerRadius, myY1 - myTargetCenter, myXCenter + myRegMarkInnerRadius)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myPaperSwatch, myNoneSwatch, myLayer
    Rem Left registration target.
    myBounds = Array(myYCenter - myRegMarkOuterRadius, (myX1 - myTargetCenter) - myRegMarkOuterRadius, myYCenter + myRegMarkOuterRadius, (myX1 - myTargetCenter) + myRegMarkOuterRadius)
    myDrawTarget myInDesign, myBounds, myRegMarkStrokeWeight, myNoneSwatch, myRegistrationSwatch, myLayer
    myBounds = Array(myYCenter, (myX1 - myTargetCenter) - myRegMarkRadius, myYCenter, (myX1 - myTargetCenter) + myRegMarkRadius)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myBounds = Array(myYCenter - myRegMarkRadius, myX1 - myTargetCenter, myYCenter + myRegMarkRadius, myX1 - myTargetCenter)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myBounds = Array(myYCenter - myRegMarkInnerRadius, myX1 - (myTargetCenter + myRegMarkInnerRadius), myYCenter + myRegMarkInnerRadius, (myX1 - myTargetCenter) + myRegMarkInnerRadius)
    myDrawTarget myInDesign, myBounds, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myBounds = Array(myYCenter, (myX1 - myTargetCenter) - myRegMarkInnerRadius, myYCenter, (myX1 - myTargetCenter) + myRegMarkInnerRadius)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myPaperSwatch, myNoneSwatch, myLayer
    myBounds = Array(myYCenter - myRegMarkInnerRadius, myX1 - myTargetCenter, myYCenter + myRegMarkInnerRadius, myX1 - myTargetCenter)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myPaperSwatch, myNoneSwatch, myLayer
    Rem Bottom registration target.
    myBounds = Array((myY2 + myTargetCenter) - myRegMarkOuterRadius, myXCenter - myRegMarkOuterRadius, (myY2 + myTargetCenter) + myRegMarkOuterRadius, myXCenter + myRegMarkOuterRadius)
    myDrawTarget myInDesign, myBounds, myRegMarkStrokeWeight, myNoneSwatch, myRegistrationSwatch, myLayer
    myBounds = Array((myY2 + myTargetCenter) - myRegMarkRadius, myXCenter, (myY2 + myTargetCenter) + myRegMarkRadius, myXCenter)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myBounds = Array(myY2 + myTargetCenter, myXCenter - myRegMarkRadius, myY2 + myTargetCenter, myXCenter + myRegMarkRadius)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myBounds = Array((myY2 + myTargetCenter) - myRegMarkInnerRadius, myXCenter - myRegMarkInnerRadius, (myY2 + myTargetCenter) + myRegMarkInnerRadius, myXCenter + myRegMarkInnerRadius)
    myDrawTarget myInDesign, myBounds, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myBounds = Array((myY2 + myTargetCenter) - myRegMarkInnerRadius, myXCenter, (myY2 + myTargetCenter) + myRegMarkInnerRadius, myXCenter)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myPaperSwatch, myNoneSwatch, myLayer
    myBounds = Array(myY2 + myTargetCenter, myXCenter - myRegMarkInnerRadius, myY2 + myTargetCenter, myXCenter + myRegMarkInnerRadius)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myPaperSwatch, myNoneSwatch, myLayer
    Rem Right registration target.
    myBounds = Array(myYCenter - myRegMarkOuterRadius, (myX2 + myTargetCenter) - myRegMarkOuterRadius, myYCenter + myRegMarkOuterRadius, (myX2 + myTargetCenter) + myRegMarkOuterRadius)
    myDrawTarget myInDesign, myBounds, myRegMarkStrokeWeight, myNoneSwatch, myRegistrationSwatch, myLayer
    myBounds = Array(myYCenter, (myX2 + myTargetCenter) - myRegMarkRadius, myYCenter, (myX2 + myTargetCenter) + myRegMarkRadius)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myBounds = Array(myYCenter - myRegMarkRadius, myX2 + myTargetCenter, myYCenter + myRegMarkRadius, myX2 + myTargetCenter)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myBounds = Array(myYCenter - myRegMarkInnerRadius, (myX2 + myTargetCenter) - myRegMarkInnerRadius, myYCenter + myRegMarkInnerRadius, (myX2 + myTargetCenter) + myRegMarkInnerRadius)
    myDrawTarget myInDesign, myBounds, myRegMarkStrokeWeight, myRegistrationSwatch, myNoneSwatch, myLayer
    myBounds = Array(myYCenter, (myX2 + myTargetCenter) - myRegMarkInnerRadius, myYCenter, (myX2 + myTargetCenter) + myRegMarkInnerRadius)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myPaperSwatch, myNoneSwatch, myLayer
    myBounds = Array(myYCenter - myRegMarkInnerRadius, myX2 + myTargetCenter, myYCenter + myRegMarkInnerRadius, myX2 + myTargetCenter)
    myDrawLine myInDesign, myBounds, myRegMarkStrokeWeight, myPaperSwatch, myNoneSwatch, myLayer
End Function
Function myDrawLine(myInDesign, myBounds, myStrokeWeight, myStrokeColor, myFillColor, myLayer)
    Set myGraphicLine = myInDesign.ActiveWindow.ActiveSpread.GraphicLines.Add
    myGraphicLine.Move , Array(1, 1)
    myGraphicLine.GeometricBounds = myBounds
    myGraphicLine.ItemLayer = myLayer
    myGraphicLine.StrokeWeight = myStrokeWeight
    myGraphicLine.FillColor = myFillColor
    myGraphicLine.StrokeColor = myStrokeColor
End Function
Function myDrawTarget(myInDesign, myBounds, myStrokeWeight, myFillColor, myStrokeColor, myLayer)
    Set myOval = myInDesign.ActiveWindow.ActiveSpread.Ovals.Add
    myOval.Move , Array(1, 1)
    myOval.ItemLayer = myLayer
    myOval.StrokeWeight = myStrokeWeight
    myOval.FillColor = myFillColor
    myOval.StrokeColor = myStrokeColor
    myOval.GeometricBounds = myBounds
End Function

'' SIG '' Begin signature block
'' SIG '' MIIeUwYJKoZIhvcNAQcCoIIeRDCCHkACAQExDzANBglg
'' SIG '' hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
'' SIG '' BgEEAYI3AgEeMCQCAQEEEE7wKRaZJ7VNj+Ws4Q8X66sC
'' SIG '' AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
'' SIG '' SWq2X7Gwbaztyao9NAjMGn7/q5FapWGfevUDujcy582g
'' SIG '' ggyUMIIF0DCCBLigAwIBAgIQB3XcWt35KITbGdVVTAfs
'' SIG '' STANBgkqhkiG9w0BAQsFADBsMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSswKQYDVQQDEyJEaWdpQ2Vy
'' SIG '' dCBFViBDb2RlIFNpZ25pbmcgQ0EgKFNIQTIpMB4XDTE5
'' SIG '' MDEzMTAwMDAwMFoXDTIxMDIwMzEyMDAwMFowgeYxEzAR
'' SIG '' BgsrBgEEAYI3PAIBAxMCVVMxGTAXBgsrBgEEAYI3PAIB
'' SIG '' AhMIRGVsYXdhcmUxHTAbBgNVBA8MFFByaXZhdGUgT3Jn
'' SIG '' YW5pemF0aW9uMRAwDgYDVQQFEwcyNzQ4MTI5MQswCQYD
'' SIG '' VQQGEwJVUzELMAkGA1UECBMCY2ExETAPBgNVBAcTCFNh
'' SIG '' biBKb3NlMRMwEQYDVQQKEwpBZG9iZSBJbmMuMSwwKgYD
'' SIG '' VQQLEyNJbGx1c3RyYXRvciwgSW5EZXNpZ24sIEluQ29w
'' SIG '' eSwgTXVzZTETMBEGA1UEAxMKQWRvYmUgSW5jLjCCASIw
'' SIG '' DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAIiKXEE3
'' SIG '' 5FJAWPRPxAu4g1GRRZmzrPW3SZL40s8opqkFWksx2dBE
'' SIG '' yP6+N6visRXUyDy+I979oO9tEtHBeYKx1XHy4NOLPl3u
'' SIG '' Lr8rWv5E3hrNw+QRwJvsMJLzBTS44811Rym8ddkt8lpj
'' SIG '' dG1PmC2aZQ73miR88+46IaZDtuabo3corXvrG0wmLFZb
'' SIG '' SrB80HAigwQiwHgh33cI2pPIYA2VdmEv5V3iI+AuYybL
'' SIG '' BPJ32YPqdvcoR3Ml/oYFcFlUb1sliNdngwqEeUTKBWVu
'' SIG '' OTeuRo2gOioizpUxR3cce25eoH8wONWUozkjPwcUEY8I
'' SIG '' RCePRf21c4kjjLGFSmpwEVQVQJcCAwEAAaOCAfEwggHt
'' SIG '' MB8GA1UdIwQYMBaAFI/ofvBtMmoABSPHcJdqOpD/a+rU
'' SIG '' MB0GA1UdDgQWBBSVoz2+cIajBhNjiGb0VJBYxDX9vzAu
'' SIG '' BgNVHREEJzAloCMGCCsGAQUFBwgDoBcwFQwTVVMtREVM
'' SIG '' QVdBUkUtMjc0ODEyOTAOBgNVHQ8BAf8EBAMCB4AwEwYD
'' SIG '' VR0lBAwwCgYIKwYBBQUHAwMwewYDVR0fBHQwcjA3oDWg
'' SIG '' M4YxaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0VWQ29k
'' SIG '' ZVNpZ25pbmdTSEEyLWcxLmNybDA3oDWgM4YxaHR0cDov
'' SIG '' L2NybDQuZGlnaWNlcnQuY29tL0VWQ29kZVNpZ25pbmdT
'' SIG '' SEEyLWcxLmNybDBLBgNVHSAERDBCMDcGCWCGSAGG/WwD
'' SIG '' AjAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
'' SIG '' Y2VydC5jb20vQ1BTMAcGBWeBDAEDMH4GCCsGAQUFBwEB
'' SIG '' BHIwcDAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGln
'' SIG '' aWNlcnQuY29tMEgGCCsGAQUFBzAChjxodHRwOi8vY2Fj
'' SIG '' ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRFVkNvZGVT
'' SIG '' aWduaW5nQ0EtU0hBMi5jcnQwDAYDVR0TAQH/BAIwADAN
'' SIG '' BgkqhkiG9w0BAQsFAAOCAQEADtCQA7go0Xu2UKN6dFPe
'' SIG '' YJbS/OXx3n3IP0K9CGPDozeGV62MvbCp+DuptFa44FYR
'' SIG '' ZuljRXMxCjsjJmkJLD9Hhuik+a23iSwfOAnWK6AY/VoD
'' SIG '' ZatWvGG6mZzMRs/s5Whztt8IRxLMrLbA+ulDkDKTlqqf
'' SIG '' BWN8xAM23VX2IMmPYFXMf1TgyT3rCr2oontG6eWT0VYa
'' SIG '' j8DrYJuWtoNQaHIxSg3lGWyvqi1RwJc7GjVwJObnRCTH
'' SIG '' Faqmfxwry/5jEDjPNNUyDiMWIr2xxCbe5pu759mb9Hjl
'' SIG '' rSakmU9AhIxEURqKA3wmnF9Sw+OnazRGp4bvfkCeWDtK
'' SIG '' LdN4JKj5eh21hDCCBrwwggWkoAMCAQICEAPxtOFfOoLx
'' SIG '' FJZ4s9fYR1wwDQYJKoZIhvcNAQELBQAwbDELMAkGA1UE
'' SIG '' BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcG
'' SIG '' A1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTErMCkGA1UEAxMi
'' SIG '' RGlnaUNlcnQgSGlnaCBBc3N1cmFuY2UgRVYgUm9vdCBD
'' SIG '' QTAeFw0xMjA0MTgxMjAwMDBaFw0yNzA0MTgxMjAwMDBa
'' SIG '' MGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
'' SIG '' dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20x
'' SIG '' KzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2lnbmlu
'' SIG '' ZyBDQSAoU0hBMikwggEiMA0GCSqGSIb3DQEBAQUAA4IB
'' SIG '' DwAwggEKAoIBAQCnU/oPsrUT8WTPhID8roA10bbXx6Ms
'' SIG '' rBosrPGErDo1EjqSkbpX5MTJ8y+oSDy31m7clyK6UXlh
'' SIG '' r0MvDbebtEkxrkRYPqShlqeHTyN+w2xlJJBVPqHKI3zF
'' SIG '' QunEemJFm33eY3TLnmMl+ISamq1FT659H8gTy3WbyeHh
'' SIG '' ivgLDJj0yj7QRap6HqVYkzY0visuKzFYZrQyEJ+d8FKh
'' SIG '' 7+g+03byQFrc+mo9G0utdrCMXO42uoPqMKhM3vELKlhB
'' SIG '' iK4AiasD0RaCICJ2615UOBJi4dJwJNvtH3DSZAmALeK2
'' SIG '' nc4f8rsh82zb2LMZe4pQn+/sNgpcmrdK0wigOXn93b89
'' SIG '' OgklAgMBAAGjggNYMIIDVDASBgNVHRMBAf8ECDAGAQH/
'' SIG '' AgEAMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggr
'' SIG '' BgEFBQcDAzB/BggrBgEFBQcBAQRzMHEwJAYIKwYBBQUH
'' SIG '' MAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBJBggr
'' SIG '' BgEFBQcwAoY9aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0SGlnaEFzc3VyYW5jZUVWUm9vdENB
'' SIG '' LmNydDCBjwYDVR0fBIGHMIGEMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsNC5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMIIBxAYDVR0gBIIBuzCC
'' SIG '' AbcwggGzBglghkgBhv1sAwIwggGkMDoGCCsGAQUFBwIB
'' SIG '' Fi5odHRwOi8vd3d3LmRpZ2ljZXJ0LmNvbS9zc2wtY3Bz
'' SIG '' LXJlcG9zaXRvcnkuaHRtMIIBZAYIKwYBBQUHAgIwggFW
'' SIG '' HoIBUgBBAG4AeQAgAHUAcwBlACAAbwBmACAAdABoAGkA
'' SIG '' cwAgAEMAZQByAHQAaQBmAGkAYwBhAHQAZQAgAGMAbwBu
'' SIG '' AHMAdABpAHQAdQB0AGUAcwAgAGEAYwBjAGUAcAB0AGEA
'' SIG '' bgBjAGUAIABvAGYAIAB0AGgAZQAgAEQAaQBnAGkAQwBl
'' SIG '' AHIAdAAgAEMAUAAvAEMAUABTACAAYQBuAGQAIAB0AGgA
'' SIG '' ZQAgAFIAZQBsAHkAaQBuAGcAIABQAGEAcgB0AHkAIABB
'' SIG '' AGcAcgBlAGUAbQBlAG4AdAAgAHcAaABpAGMAaAAgAGwA
'' SIG '' aQBtAGkAdAAgAGwAaQBhAGIAaQBsAGkAdAB5ACAAYQBu
'' SIG '' AGQAIABhAHIAZQAgAGkAbgBjAG8AcgBwAG8AcgBhAHQA
'' SIG '' ZQBkACAAaABlAHIAZQBpAG4AIABiAHkAIAByAGUAZgBl
'' SIG '' AHIAZQBuAGMAZQAuMB0GA1UdDgQWBBSP6H7wbTJqAAUj
'' SIG '' x3CXajqQ/2vq1DAfBgNVHSMEGDAWgBSxPsNpA/i/RwHU
'' SIG '' mCYaCALvY2QrwzANBgkqhkiG9w0BAQsFAAOCAQEAGTNK
'' SIG '' DIEzN9utNsnkyTq7tRsueqLi9ENCF56/TqFN4bHb6YHd
'' SIG '' nwHy5IjV6f4J/SHB7F2A0vDWwUPC/ncr2/nXkTPObNWy
'' SIG '' GTvmLtbJk0+IQI7N4fV+8Q/GWVZy6OtqQb0c1UbVfEnK
'' SIG '' ZjgVwb/gkXB3h9zJjTHJDCmiM+2N4ofNiY0/G//V4BqX
'' SIG '' i3zabfuoxrI6Zmt7AbPN2KY07BIBq5VYpcRTV6hg5ucC
'' SIG '' EqC5I2SiTbt8gSVkIb7P7kIYQ5e7pTcGr03/JqVNYUvs
'' SIG '' RkG4Zc64eZ4IlguBjIo7j8eZjKMqbphtXmHGlreKuWEt
'' SIG '' k7jrDgRD1/X+pvBi1JlqpcHB8GSUgDGCERcwghETAgEB
'' SIG '' MIGAMGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdp
'' SIG '' Q2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
'' SIG '' b20xKzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2ln
'' SIG '' bmluZyBDQSAoU0hBMikCEAd13Frd+SiE2xnVVUwH7Ekw
'' SIG '' DQYJYIZIAWUDBAIBBQCggZwwGQYJKoZIhvcNAQkDMQwG
'' SIG '' CisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisG
'' SIG '' AQQBgjcCARUwLwYJKoZIhvcNAQkEMSIEIGxtmK9T5ib8
'' SIG '' X/zOOwAx0TWhHbyS/c29UgU3i8UkIgR5MDAGCisGAQQB
'' SIG '' gjcCAQwxIjAgoB6AHABBAGQAbwBiAGUAIABJAG4ARABl
'' SIG '' AHMAaQBnAG4wDQYJKoZIhvcNAQEBBQAEggEAO+jIRkZc
'' SIG '' hL3WeN+DlwiO5/CkfheKYzKyxY6drjIKLDyt/HLSuBg0
'' SIG '' NtcmK3hGNXv6gT3is2QZBYTDyroGg1yelIZZMtQICwuI
'' SIG '' dm3ZKGvN7KJD6IFp01UZq5okDEAMe5aeWuViQunOjmY6
'' SIG '' I62IXkezF7HwSL8DwAnr2D9CVGYMQvr68V90MnevdBYU
'' SIG '' skmcqIkRz6YK2R/e40KEzZbmdvJT0VbS2XweyRMlZ70t
'' SIG '' d3110U/7up/xAJpiD5nmqrGDJPub6QBlQBypEfdVPIPD
'' SIG '' 0OHqfib/SKoMbIA7pRlOwUYdR92gCALf46dE3hf7Eb/B
'' SIG '' 9rqu3pc5LoeMRj8pLGhHwrhH6qGCDsgwgg7EBgorBgEE
'' SIG '' AYI3AwMBMYIOtDCCDrAGCSqGSIb3DQEHAqCCDqEwgg6d
'' SIG '' AgEDMQ8wDQYJYIZIAWUDBAIBBQAwdwYLKoZIhvcNAQkQ
'' SIG '' AQSgaARmMGQCAQEGCWCGSAGG/WwHATAxMA0GCWCGSAFl
'' SIG '' AwQCAQUABCCJc+G1JpR5st0bNRQvvWuw5wBG15g9BMu4
'' SIG '' NqwVHmvPjgIQEG++PvTwoD7cqlXQAPkyxBgPMjAyMDEw
'' SIG '' MDQwMDIyMThaoIILuzCCBoIwggVqoAMCAQICEATNP4Vo
'' SIG '' rnbGG7D+cWDMp20wDQYJKoZIhvcNAQELBQAwcjELMAkG
'' SIG '' A1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZ
'' SIG '' MBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UE
'' SIG '' AxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIFRpbWVz
'' SIG '' dGFtcGluZyBDQTAeFw0xOTEwMDEwMDAwMDBaFw0zMDEw
'' SIG '' MTcwMDAwMDBaMEwxCzAJBgNVBAYTAlVTMRcwFQYDVQQK
'' SIG '' Ew5EaWdpQ2VydCwgSW5jLjEkMCIGA1UEAxMbVElNRVNU
'' SIG '' QU1QLVNIQTI1Ni0yMDE5LTEwLTE1MIIBIjANBgkqhkiG
'' SIG '' 9w0BAQEFAAOCAQ8AMIIBCgKCAQEA6WQ1nPqpmGVkG+QX
'' SIG '' 3LgpNsxnCViFTTDgyf/lOzwRKFCvBzHiXQkYwvaJjGkI
'' SIG '' BCPgdy2dFeW46KFqjv/UrtJ6Fu/4QbUdOXXBzy+nrEV+
'' SIG '' lG2sAwGZPGI+fnr9RZcxtPq32UI+p1Wb31pPWAKoMmki
'' SIG '' E76Lgi3GmKtrm7TJ8mURDHQNsvAIlnTE6LJIoqEUpfj6
'' SIG '' 4YlwRDuN7/uk9MO5vRQs6wwoJyWAqxBLFhJgC2kijE7N
'' SIG '' xtWyZVkh4HwsEo1wDo+KyuDT17M5d1DQQiwues6cZ3o4
'' SIG '' d1RA/0+VBCDU68jOhxQI/h2A3dDnK3jqvx9wxu5CFlM2
'' SIG '' RZtTGUlinXoCm5UUowIDAQABo4IDODCCAzQwDgYDVR0P
'' SIG '' AQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0lAQH/
'' SIG '' BAwwCgYIKwYBBQUHAwgwggG/BgNVHSAEggG2MIIBsjCC
'' SIG '' AaEGCWCGSAGG/WwHATCCAZIwKAYIKwYBBQUHAgEWHGh0
'' SIG '' dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwggFkBggr
'' SIG '' BgEFBQcCAjCCAVYeggFSAEEAbgB5ACAAdQBzAGUAIABv
'' SIG '' AGYAIAB0AGgAaQBzACAAQwBlAHIAdABpAGYAaQBjAGEA
'' SIG '' dABlACAAYwBvAG4AcwB0AGkAdAB1AHQAZQBzACAAYQBj
'' SIG '' AGMAZQBwAHQAYQBuAGMAZQAgAG8AZgAgAHQAaABlACAA
'' SIG '' RABpAGcAaQBDAGUAcgB0ACAAQwBQAC8AQwBQAFMAIABh
'' SIG '' AG4AZAAgAHQAaABlACAAUgBlAGwAeQBpAG4AZwAgAFAA
'' SIG '' YQByAHQAeQAgAEEAZwByAGUAZQBtAGUAbgB0ACAAdwBo
'' SIG '' AGkAYwBoACAAbABpAG0AaQB0ACAAbABpAGEAYgBpAGwA
'' SIG '' aQB0AHkAIABhAG4AZAAgAGEAcgBlACAAaQBuAGMAbwBy
'' SIG '' AHAAbwByAGEAdABlAGQAIABoAGUAcgBlAGkAbgAgAGIA
'' SIG '' eQAgAHIAZQBmAGUAcgBlAG4AYwBlAC4wCwYJYIZIAYb9
'' SIG '' bAMVMB8GA1UdIwQYMBaAFPS24SAd/imu0uRhpbKiJbLI
'' SIG '' FzVuMB0GA1UdDgQWBBRWUw/BxgenTdfYbldygFBM5Oye
'' SIG '' wTBxBgNVHR8EajBoMDKgMKAuhixodHRwOi8vY3JsMy5k
'' SIG '' aWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLXRzLmNybDAy
'' SIG '' oDCgLoYsaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3No
'' SIG '' YTItYXNzdXJlZC10cy5jcmwwgYUGCCsGAQUFBwEBBHkw
'' SIG '' dzAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNl
'' SIG '' cnQuY29tME8GCCsGAQUFBzAChkNodHRwOi8vY2FjZXJ0
'' SIG '' cy5kaWdpY2VydC5jb20vRGlnaUNlcnRTSEEyQXNzdXJl
'' SIG '' ZElEVGltZXN0YW1waW5nQ0EuY3J0MA0GCSqGSIb3DQEB
'' SIG '' CwUAA4IBAQAug6FEBUoE47kyUvrZgfAau/gJjSO5PdiS
'' SIG '' oeZGHEovbno8Y243F6Mav1gjskOclINOOQmwLOjH4eLM
'' SIG '' 7ct5a87eIwFH7ZVUgeCAexKxrwKGqTpzav74n8GN0SGM
'' SIG '' 5CmCw4oLYAACnR9HxJ+0CmhTf1oQpvgi5vhTkjFf2IKD
'' SIG '' LW0TQq6DwRBOpCT0R5zeDyJyd1x/T+k5mCtXkkTX726T
'' SIG '' 2UPHBDNjUTdWnkcEEcOjWFQh2OKOVtdJP1f8Cp8jXnv0
'' SIG '' lI3dnRq733oqptJFplUMj/ZMivKWz4lG3DGykZCjXzMw
'' SIG '' YFX1/GswrKHt5EdOM55naii1TcLtW5eC+MupCGxTCbT3
'' SIG '' MIIFMTCCBBmgAwIBAgIQCqEl1tYyG35B5AXaNpfCFTAN
'' SIG '' BgkqhkiG9w0BAQsFADBlMQswCQYDVQQGEwJVUzEVMBMG
'' SIG '' A1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
'' SIG '' ZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBB
'' SIG '' c3N1cmVkIElEIFJvb3QgQ0EwHhcNMTYwMTA3MTIwMDAw
'' SIG '' WhcNMzEwMTA3MTIwMDAwWjByMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2Vy
'' SIG '' dCBTSEEyIEFzc3VyZWQgSUQgVGltZXN0YW1waW5nIENB
'' SIG '' MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
'' SIG '' vdAy7kvNj3/dqbqCmcU5VChXtiNKxA4HRTNREH3Q+X1N
'' SIG '' aH7ntqD0jbOI5Je/YyGQmL8TvFfTw+F+CNZqFAA49y4e
'' SIG '' O+7MpvYyWf5fZT/gm+vjRkcGGlV+Cyd+wKL1oODeIj8O
'' SIG '' /36V+/OjuiI+GKwR5PCZA207hXwJ0+5dyJoLVOOoCXFr
'' SIG '' 4M8iEA91z3FyTgqt30A6XLdR4aF5FMZNJCMwXbzsPGBq
'' SIG '' rC8HzP3w6kfZiFBe/WZuVmEnKYmEUeaC50ZQ/ZQqLKfk
'' SIG '' dT66mA+Ef58xFNat1fJky3seBdCEGXIX8RcG7z3N1k3v
'' SIG '' BkL9olMqT4UdxB08r8/arBD13ays6Vb/kwIDAQABo4IB
'' SIG '' zjCCAcowHQYDVR0OBBYEFPS24SAd/imu0uRhpbKiJbLI
'' SIG '' FzVuMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6enIZ3z
'' SIG '' bcgPMBIGA1UdEwEB/wQIMAYBAf8CAQAwDgYDVR0PAQH/
'' SIG '' BAQDAgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMIMHkGCCsG
'' SIG '' AQUFBwEBBG0wazAkBggrBgEFBQcwAYYYaHR0cDovL29j
'' SIG '' c3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRw
'' SIG '' Oi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRB
'' SIG '' c3N1cmVkSURSb290Q0EuY3J0MIGBBgNVHR8EejB4MDqg
'' SIG '' OKA2hjRodHRwOi8vY3JsNC5kaWdpY2VydC5jb20vRGln
'' SIG '' aUNlcnRBc3N1cmVkSURSb290Q0EuY3JsMDqgOKA2hjRo
'' SIG '' dHRwOi8vY3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRB
'' SIG '' c3N1cmVkSURSb290Q0EuY3JsMFAGA1UdIARJMEcwOAYK
'' SIG '' YIZIAYb9bAACBDAqMCgGCCsGAQUFBwIBFhxodHRwczov
'' SIG '' L3d3dy5kaWdpY2VydC5jb20vQ1BTMAsGCWCGSAGG/WwH
'' SIG '' ATANBgkqhkiG9w0BAQsFAAOCAQEAcZUS6VGHVmnN793a
'' SIG '' fKpjerN4zwY3QITvS4S/ys8DAv3Fp8MOIEIsr3fzKx8M
'' SIG '' IVoqtwU0HWqumfgnoma/Capg33akOpMP+LLR2HwZYuhe
'' SIG '' giUexLoceywh4tZbLBQ1QwRostt1AuByx5jWPGTlH0gQ
'' SIG '' GF+JOGFNYkYkh2OMkVIsrymJ5Xgf1gsUpYDXEkdws3XV
'' SIG '' k4WTfraSZ/tTYYmo9WuWwPRYaQ18yAGxuSh1t5ljhSKM
'' SIG '' Ycp5lH5Z/IwP42+1ASa2bKXuh1Eh5Fhgm7oMLSttosR+
'' SIG '' u8QlK0cCCHxJrhO24XxCQijGGFbPQTS2Zl22dHv1VjMi
'' SIG '' LyI2skuiSpXY9aaOUjGCAk0wggJJAgEBMIGGMHIxCzAJ
'' SIG '' BgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMx
'' SIG '' GTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xMTAvBgNV
'' SIG '' BAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJlZCBJRCBUaW1l
'' SIG '' c3RhbXBpbmcgQ0ECEATNP4VornbGG7D+cWDMp20wDQYJ
'' SIG '' YIZIAWUDBAIBBQCggZgwGgYJKoZIhvcNAQkDMQ0GCyqG
'' SIG '' SIb3DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMDEwMDQw
'' SIG '' MDIyMThaMCsGCyqGSIb3DQEJEAIMMRwwGjAYMBYEFAMl
'' SIG '' vVBe2pYwLcIvT6AeTCi+KDTFMC8GCSqGSIb3DQEJBDEi
'' SIG '' BCCKMeiaZPUr9V/hgtRvm9idg/6XJyWcIjC9Ro1UIiQC
'' SIG '' gDANBgkqhkiG9w0BAQEFAASCAQAA45W/of2vBtWBDV9f
'' SIG '' 1lJ8X1O3ogdQX7qE/+CzGp1XeDQvZHkhgBjlWeicW15M
'' SIG '' rI9lwgEH94/gB0mi44ttlrR1ci2DJY8dRwEtlicMS5LE
'' SIG '' 14uLdM25Mxk5rORw0eVy7N0Mr7IVVhdmn0UjyRl62YV2
'' SIG '' PZPxzBT1eOnVolathgoM0oXGhtru3uB3OYd99YrQtMAk
'' SIG '' F8XWxdg+EeyIzmrmUTuq+mm86Pd1InIhK5m22WpMzaOT
'' SIG '' nPnAHj2ghfAcvYTAAXoPbyr08oaUeNSGobV3MqmLFFvX
'' SIG '' VkGs55ez+Yub9XRyM5+mpj+12PbdNbhHjeuKE8zgTSWW
'' SIG '' afan6hjXSPWnVbBG
'' SIG '' End signature block
